/*!\file BoolInput.c
 * \brief: implementation of the BoolInput object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../include/include.h"

/*Object constructors and destructor*/
/*FUNCTION BoolInput::BoolInput(){{{1*/
BoolInput::BoolInput(){
	return;
}
/*}}}*/
/*FUNCTION BoolInput::BoolInput(double* values){{{1*/
BoolInput::BoolInput(int in_enum_type,IssmBool in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION BoolInput::~BoolInput(){{{1*/
BoolInput::~BoolInput(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION BoolInput::copy{{{1*/
Object* BoolInput::copy() {
	
	return new BoolInput(this->enum_type,this->value);

}
/*}}}*/
/*FUNCTION BoolInput::DeepEcho{{{1*/
void BoolInput::DeepEcho(void){

	printf("BoolInput:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumAsString(this->enum_type));
	printf("   value: %s\n",value?"true":"false");
}
/*}}}*/
/*FUNCTION BoolInput::Demarshall{{{1*/
void  BoolInput::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&value,marshalled_dataset,sizeof(value));marshalled_dataset+=sizeof(value);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION BoolInput::Echo {{{1*/
void BoolInput::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION BoolInput::Enum{{{1*/
int BoolInput::Enum(void){

	return BoolInputEnum;

}
/*}}}*/
/*FUNCTION BoolInput::EnumType{{{1*/
int BoolInput::EnumType(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION BoolInput::Id{{{1*/
int    BoolInput::Id(void){ return -1; }
/*}}}*/
/*FUNCTION BoolInput::Marshall{{{1*/
void  BoolInput::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of BoolInput: */
	enum_value=BoolInputEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall BoolInput data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&value,sizeof(value));marshalled_dataset+=sizeof(value);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION BoolInput::MarshallSize{{{1*/
int   BoolInput::MarshallSize(){
	
	return sizeof(value)+
		+sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION BoolInput::MyRank{{{1*/
int    BoolInput::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION BoolInput::SpawnSingInput{{{1*/
Input* BoolInput::SpawnSingInput(int index){

	/*output*/
	BoolInput* outinput=new BoolInput();

	/*only copy current value*/
	outinput->enum_type=this->enum_type;
	outinput->value=this->value;

	/*Assign output*/
	return outinput;

}
/*}}}*/
/*FUNCTION BoolInput::SpawnBeamInput{{{1*/
Input* BoolInput::SpawnBeamInput(int* indices){

	/*output*/
	BoolInput* outinput=new BoolInput();

	/*only copy current value*/
	outinput->enum_type=this->enum_type;
	outinput->value=this->value;

	/*Assign output*/
	return outinput;

}
/*}}}*/
/*FUNCTION BoolInput::SpawnTriaInput{{{1*/
Input* BoolInput::SpawnTriaInput(int* indices){

		/*output*/
		BoolInput* outinput=new BoolInput();

		/*only copy current value*/
		outinput->enum_type=this->enum_type;
		outinput->value=this->value;

		/*Assign output*/
		return outinput;

}
/*}}}*/
/*FUNCTION BoolInput::SpawnResult{{{1*/
ElementResult* BoolInput::SpawnResult(int step, double time){

	ISSMERROR(" not supported yet!");

}
/*}}}*/

/*Object functions*/
/*FUNCTION BoolInput::GetParameterValue(bool* pvalue) {{{1*/
void BoolInput::GetParameterValue(bool* pvalue){
	*pvalue=value;
}
/*}}}*/
/*FUNCTION BoolInput::GetParameterValue(int* pvalue){{{1*/
void BoolInput::GetParameterValue(int* pvalue){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BoolInput::GetParameterValue(double* pvalue){{{1*/
void BoolInput::GetParameterValue(double* pvalue){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BoolInput::GetParameterValue(double* pvalue,Node* node){{{1*/
void BoolInput::GetParameterValue(double* pvalue,Node* node){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BoolInput::GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord){{{1*/
void BoolInput::GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BoolInput::GetParameterValue(double* pvalue,double* gauss){{{1*/
void BoolInput::GetParameterValue(double* pvalue,double* gauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BoolInput::GetParameterValue(double* pvalue,double* gauss,double defaultvalue){{{1*/
void BoolInput::GetParameterValue(double* pvalue,double* gauss,double defaultvalue){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BoolInput::GetParameterValues(double* values,double* gauss_pointers, int numgauss){{{1*/
void BoolInput::GetParameterValues(double* values,double* gauss_pointers, int numgauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BoolInput::GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss){{{1*/
void BoolInput::GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BoolInput::ChangeEnum(int newenumtype){{{1*/
void BoolInput::ChangeEnum(int newenumtype){
	this->enum_type=newenumtype;
}
/*}}}*/
/*FUNCTION BoolInput::SquareMin(double* psquaremin, bool process_units){{{1*/
void BoolInput::SquareMin(double* psquaremin, bool process_units,Parameters* parameters){
	/*square of a bool is the bool itself: */
	*psquaremin=value;
}
/*}}}*/
/*FUNCTION BoolInput::Scale(double scale_factor){{{1*/
void BoolInput::Scale(double scale_factor){
	/*a bool cannot be scaled: */
}
/*}}}*/
/*FUNCTION BoolInput::AXPY(Input* xinput,double scalar);{{{1*/
void BoolInput::AXPY(Input* xinput,double scalar){

	BoolInput*  xboolinput=NULL;

	/*xinput is of the same type, so cast it: */
	xboolinput=(BoolInput*)xinput;

	/*Carry out the AXPY operation depending on type:*/
	switch(xinput->Enum()){

		case BoolInputEnum:
			this->value=(bool)(this->value+scalar*xboolinput->value);
			return;

		default:
			ISSMERROR("not implemented yet");
	}

}
/*}}}*/
/*FUNCTION BoolInput::Constrain(double cm_min, double cm_max){{{1*/
void BoolInput::Constrain(double cm_min, double cm_max){

	if(!isnan(cm_min)) if (this->value<cm_min)this->value=cm_min;
	if(!isnan(cm_max)) if (this->value>cm_max)this->value=cm_max;

}
/*}}}*/
/*FUNCTION BoolInput::GetVectorFromInputs(Vec vector,int* doflist){{{1*/
void BoolInput::GetVectorFromInputs(Vec vector,int* doflist){

	ISSMERROR(" not supporte yet!");

}
/*}}}*/
/*FUNCTION BoolInput::GetValuesPtr(double** pvalues,int* pnum_values);{{{1*/
void BoolInput::GetValuesPtr(double** pvalues,int* pnum_values){

	ISSMERROR(" not supported yet!");

}
/*}}}*/
