/*\file VerticesDof.c
 *\brief: build degrees of freedom for every vertex
 */

#include "./VerticesDof.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* vertices=NULL;
	Parameters* parameters=NULL;

	/* output datasets: */
	DofVec* partition=NULL;
	DofVec* tpartition=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&VerticesDofUsage);

	/*Input datasets: */
	FetchData(&vertices,VERTICESIN);
	FetchData((DataSet**)&parameters,PARAMETERS);

	/*!Generate internal degree of freedom numbers: */
	VerticesDofx(&partition, &tpartition, vertices, parameters); 

	/*partition and tpartition should be incremented by 1: */
	VecShift(partition->vector,1.0); //matlab indexing starts at 1.
	VecShift(tpartition->vector,1.0);

	/*write output datasets: */
	WriteData(VERTICES,vertices);
	WriteData(PARTITION,partition);
	WriteData(TPARTITION,tpartition);

	/*Free ressources: */
	delete vertices;
	delete parameters;
	delete partition;
	delete tpartition;

	/*end module: */
	MODULEEND();
}

void VerticesDofUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [vertices,part,tpart] = %s(vertices,parameters);\n",__FUNCT__);
	_printf_("\n");
}
