/*!\file VerticesDofx
 * \brief: establish degrees of freedom for all vertices, and return partitioning vector. Do only once.
 */

#include "./VerticesDofx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void VerticesDofx( Vec* ppartition, Vec* ptpartition, DataSet* vertices, Parameters* parameters) {

	int i;

	int  found=0;
	extern int num_procs;
	extern int my_rank;
	
	/*intermediary: */
	int  numberofvertices;

	/*output: */
	Vec partition=NULL;
	Vec tpartition=NULL;

	if(*ppartition) return; //do not create partition vector twice! we only have on set of vertices

	/*figure out how many vertices we have: */
	vertices->NumberOfVertices(&numberofvertices);

	/*Ensure that only for each cpu, the partition border vertices only will be taken into account once 
	 * across the cluster. To do so, we flag all the clone vertices: */
	vertices->FlagClones(numberofvertices);

	/*Go through all vertices and distribute 1 dof at a time. When a  vertex has already been distributed his dof on a cpu, 
	 * all other cpus with the same vertex cannot distribute it anymore. Use clone field to be sure of that: */
	vertices->DistributeDofs(numberofvertices,1); //only 1 dof per vertex.

	/*Now that dofs have been distributed, create partitioning vector and its transpose: */
	vertices->CreatePartitioningVector(&partition,numberofvertices);

	/*Transpose partition into tpartition: */
	VecTranspose(&tpartition,partition);

	/*Assign output pointers: */
	*ppartition=partition;
	*ptpartition=tpartition;
	
}
