/*!\file: MatlabWriteResults.cpp
 * \brief: write results into a matlab array
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_

#include <mex.h>
#include "../../io/io.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/include.h"

void  MatlabWriteResults(mxArray** pdataref, Parameters* parameters, DataSet* results){

	int i;

	/*output: */
	mxArray* dataref=NULL;
	mwSize nfields;
	const	char**	fnames=NULL;
	mwSize		onebyone[2] = {1,1};
	mwSize		ndim=2;

	/*How many results? : */
	nfields=(mwSize)results->Size();

	/*recover names: */
	fnames=(const char**)xmalloc(nfields*sizeof(char*));
	for(i=0;i<nfields;i++){
		ExternalResult* result=(ExternalResult*)results->GetObjectByOffset(i);
		fnames[i]=result->GetResultName();
	}

	/*Initialize structure: */
	dataref=mxCreateStructArray( ndim,onebyone,nfields,fnames);

	/*Fill each field: */
	for(i=0;i<nfields;i++){

		ExternalResult* result=(ExternalResult*)results->GetObjectByOffset(i);
		result->SetMatlabField(dataref);
	}
	
	/*Assign output pointers:*/
	*pdataref=dataref;

}
#endif
