/*!\file BoolExternalResult.c
 * \brief: implementation of the BoolExternalResult object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../include/include.h"
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION BoolExternalResult::BoolExternalResult(){{{1*/
BoolExternalResult::BoolExternalResult(){
	return;
}
/*}}}*/
/*FUNCTION BoolExternalResult::BoolExternalResult(int enum_type,bool value){{{1*/
BoolExternalResult::BoolExternalResult(int in_id, int in_enum_type,bool in_value,int in_step, double in_time){

	id=in_id;
	enum_type=in_enum_type;
	value=in_value;
	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION BoolExternalResult::~BoolExternalResult(){{{1*/
BoolExternalResult::~BoolExternalResult(){
	return;
}
/*}}}*/

/*Object methods*/
/*FUNCTION BoolExternalResult::copy{{{1*/
Object* BoolExternalResult::copy() {
	
	return new BoolExternalResult(this->id,this->enum_type,this->value,this->step,this->time);

}
/*}}}*/
/*FUNCTION BoolExternalResult::DeepEcho{{{1*/
void BoolExternalResult::DeepEcho(void){

	printf("BoolExternalResult:\n");
	printf("   id: %i\n",this->id);
	printf("   enum:  %i (%s)\n",this->enum_type,EnumAsString(this->enum_type));
	printf("   value: %s\n",this->value?"true":"false");
	printf("   step: %i\n",this->step);
	printf("   time: %g\n",this->time);
}
/*}}}*/
/*FUNCTION BoolExternalResult::Demarshall{{{1*/
void  BoolExternalResult::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&id,marshalled_dataset,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&value,marshalled_dataset,sizeof(value));marshalled_dataset+=sizeof(value);
	memcpy(&step,marshalled_dataset,sizeof(step));marshalled_dataset+=sizeof(step);
	memcpy(&time,marshalled_dataset,sizeof(time));marshalled_dataset+=sizeof(time);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION BoolExternalResult::Echo {{{1*/
void BoolExternalResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION BoolExternalResult::Enum{{{1*/
int BoolExternalResult::Enum(void){

	return BoolExternalResultEnum;

}
/*}}}*/
/*FUNCTION BoolExternalResult::Id{{{1*/
int    BoolExternalResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION BoolExternalResult::Marshall{{{1*/
void  BoolExternalResult::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of BoolExternalResult: */
	enum_value=BoolExternalResultEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall BoolExternalResult data: */
	memcpy(marshalled_dataset,&id,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&value,sizeof(value));marshalled_dataset+=sizeof(value);
	memcpy(marshalled_dataset,&step,sizeof(step));marshalled_dataset+=sizeof(step);
	memcpy(marshalled_dataset,&time,sizeof(time));marshalled_dataset+=sizeof(time);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION BoolExternalResult::MarshallSize{{{1*/
int   BoolExternalResult::MarshallSize(){
	
	return sizeof(value)+
		+sizeof(id)
		+sizeof(enum_type)
		+sizeof(step)
		+sizeof(time)
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION BoolExternalResult::MyRank{{{1*/
int    BoolExternalResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/

/*Numerics: */
/*FUNCTION BoolExternalResult::WriteData(FILE* fid) {{{1*/
void   BoolExternalResult::WriteData(FILE* fid){

	int     length;
	int     type;
	int     size;
	char   *name    = NULL;
	double  boolean;
	extern  int my_rank;

	/*return if now on cpu 0: */
	if(my_rank)return;

	/*First write enum: */
	name=EnumAsString(this->enum_type);
	length=(strlen(name)+1)*sizeof(char);
	fwrite(&length,sizeof(int),1,fid);
	fwrite(name,length,1,fid);

	/*Now write time and step: */
	fwrite(&time,sizeof(double),1,fid);
	fwrite(&step,sizeof(int),1,fid);

	/*Now write bool, after casting it: */
	boolean=(double)this->value;

	/*writing a double, type is 1, size is 1: */
	type=1;
	size=1;
	fwrite(&type,sizeof(int),1,fid);
	fwrite(&size,sizeof(int),1,fid);
	fwrite(&boolean,size*sizeof(double),1,fid);

}
/*}}}1*/
/*FUNCTION BoolExternalResult::GetResultName(void); {{{1*/
char* BoolExternalResult::GetResultName(void){
	return  EnumAsString(this->enum_type);
}
/*}}}*/
/*FUNCTION BoolExternalResult::SetMatlabField(mxArray* dataref);{{{1*/
#ifdef _SERIAL_
char* BoolExternalResult::SetMatlabField(mxArray* dataref){

	char* name=NULL;
	name=this->GetResultName();
	mxSetField( dataref, 0, name,mxCreateDoubleScalar((double)value));
}
#endif
/*}}}*/
