/*!\file:  OutputResultsx.h
 * \brief header file for outputing results
 */ 

#ifndef _OUTPUTRESULTS_H
#define _OUTPUTRESULTS_H

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

class DataSet;
class Parameters;

#ifdef _SERIAL_
void OutputResultsx(mxArray** pdataref, DataSet* elements, DataSet* loads, DataSet* nodes, DataSet* vertices, DataSet* materials, Parameters* parameters,DataSet* results);
#else
void OutputResultsx(DataSet* elements, DataSet* loads, DataSet* nodes, DataSet* vertices, DataSet* materials, Parameters* parameters,DataSet* results);
#endif

/* local prototypes: */
void ElementResultsToPatch(DataSet* elements, DataSet* loads, DataSet* nodes, DataSet* vertices, DataSet* materials, Parameters* parameters,DataSet* results);
void FileWriteResults(Parameters* parameters, DataSet* results);
void MatlabWriteResults(mxArray** pdataref, Parameters* parameters, DataSet* results);

#endif  /* _OUTPUTRESULTS_H */

