/*!\file: FileWriteResults.cpp
 * \brief: write results in femmodel->results to disk
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

void FileWriteResults(Parameters* parameters, DataSet* results){

	extern int  my_rank;
	char       *filename     = NULL;
	FILE       *fid          = NULL;

	//Recover file name: 
	parameters->FindParam(&filename,OutputFileNameEnum);

	//Open filename for writing only on cpu 0
	if(my_rank==0)fid=pfopen(filename,"wb");

	for(i=0;i<results->Size();i++){
		ExternalResult* result=(ExternalResult*)results->GetObjectByOffset(i);

		/*write result to disk: */
		result->WriteData(fid);
	}

	/*Close file: */
	if(my_rank==0)pfclose(fid,filename);

	/*Free ressources:*/
	xfree((void**)&filename);
}
