/*!\file UpdateGeometryx
 * \brief: update geometry node by node
 */

#include "./UpdateGeometryx.h"
#include "../modules.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../DataSet/DataSet.h"

void UpdateGeometryx( DataSet* elements, DataSet* nodes, DataSet* vertices,DataSet* loads, DataSet* materials, Parameters* parameters){

	int i;
	int dof;

	ISSMERROR(" not support yet! needs to be redone at the element level!");

	/*vectorized inputs: */
	Vec     vec_newthickness=NULL;
	Vec     vec_bed=NULL;
	Vec     vec_surface=NULL;
	double* newthickness=NULL;
	double* bed=NULL;
	double* surface=NULL;

	/*objects: */
	Node* node=NULL;
	Object* object=NULL;
	Matpar* matpar=NULL;

	/*parameters: */
	double h,b,s;
	double rho_ice,rho_water;

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements,loads, nodes,vertices, materials,parameters);
	materials->Configure(elements, loads, nodes,vertices, materials,parameters);
	loads->Configure(elements, loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*retrieve inputs: */
	GetVectorFromInputsx( &vec_newthickness, elements, nodes,  vertices,  loads,  materials,  parameters, ThicknessEnum,VertexEnum);
	GetVectorFromInputsx( &vec_bed, elements, nodes,  vertices,  loads,  materials,  parameters, ThicknessEnum,VertexEnum);
	GetVectorFromInputsx( &vec_surface, elements, nodes,  vertices,  loads,  materials,  parameters, ThicknessEnum,VertexEnum);

	VecToMPISerial(&newthickness,vec_newthickness);
	VecToMPISerial(&bed,vec_bed);
	VecToMPISerial(&surface,vec_surface);

	/*First, find the matpar object in materials: */
	for(i=0;i<materials->Size();i++){
		Object* object=materials->GetObjectByOffset(i);
		if  (object->Enum()==MatparEnum){
			matpar=(Matpar*)object;
			break;
		}
	}

	/*recover material parameters: */
	rho_ice=matpar->GetRhoIce();
	rho_water=matpar->GetRhoWater();

	/*Go through nodes and for each node, update the thickness, bed and surface, using the 
	 * new thickness computed in the prognostic_core part of the transient solution sequence: */

	for(i=0;i<nodes->Size();i++){

		/*get i'th node: */
		node=(Node*)vertices->GetObjectByOffset(i);

		/*first, recover thickness, surface and bed for this node: */
		h=newthickness[dof];
		s=surface[dof];
		b=bed[dof];

		//First, check that thickness is >0
		if(h<0)h=10; 

		//For grids on ice sheet, the new bed remains the same, the new surface becomes bed+new_thickness. 
		if (node->IsOnSheet()){
			s=b+h;
		}

		//For grids on ice shelt, we have hydrostatic equilibrium (for now)
		if (node->IsOnShelf()){
			b=-rho_ice/rho_water*h;
			s=(1-rho_ice/rho_water)*h;
		}

		/*Ok, plug values of thickness, surafce and bed into our outputs: */
		VecSetValues(vec_newthickness,1,&dof,&h,INSERT_VALUES);
		VecSetValues(vec_bed,1,&dof,&b,INSERT_VALUES);
		VecSetValues(vec_surface,1,&dof,&s,INSERT_VALUES);
	}

	/*Assemble vectors: */
	VecAssemblyBegin(vec_newthickness);
	VecAssemblyEnd(vec_newthickness);

	VecAssemblyBegin(vec_bed);
	VecAssemblyEnd(vec_bed);

	VecAssemblyBegin(vec_surface);
	VecAssemblyEnd(vec_surface);

	/*Put back into inputs:*/
	InputUpdateFromVectorx( elements,nodes, vertices,loads, materials,  parameters,vec_newthickness,ThicknessEnum,VertexEnum); //clobber existing thickness input with new one
	InputUpdateFromVectorx( elements,nodes, vertices,loads, materials,  parameters,vec_bed,BedEnum,VertexEnum); 
	InputUpdateFromVectorx( elements,nodes, vertices,loads, materials,  parameters,vec_surface,SurfaceEnum,VertexEnum); 

	/*Free ressources:*/
	VecFree(&vec_newthickness);
	VecFree(&vec_bed);
	VecFree(&vec_surface);
	xfree((void**)&newthickness);
	xfree((void**)&bed);
	xfree((void**)&surface);
	
}
