/*!\file DoubleMatExternalResult.c
 * \brief: implementation of the DoubleMatExternalResult object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../include/include.h"
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION DoubleMatExternalResult::DoubleMatExternalResult(){{{1*/
DoubleMatExternalResult::DoubleMatExternalResult(){
	return;
}
/*}}}*/
/*FUNCTION DoubleMatExternalResult::DoubleMatExternalResult(int in_id, int enum_type,IssmDoubleMat values,int M,int N,int in_step,double in_time){{{1*/
DoubleMatExternalResult::DoubleMatExternalResult(int in_id, int in_enum_type,double* in_values, int in_M,int in_N,int in_step,double in_time){

	id=in_id;
	enum_type=in_enum_type;
	M=in_M;
	N=in_N;

	values=(double*)xmalloc(M*N*sizeof(double));
	memcpy(values,in_values,M*N*sizeof(double));

	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION DoubleMatExternalResult::~DoubleMatExternalResult(){{{1*/
DoubleMatExternalResult::~DoubleMatExternalResult(){
	xfree((void**)&values);
	return;
}
/*}}}*/

/*Object methods*/
/*FUNCTION DoubleMatExternalResult::copy{{{1*/
Object* DoubleMatExternalResult::copy() {
	
	return new DoubleMatExternalResult(this->id,this->enum_type,this->values,this->M,this->N,this->step,this->time);

}
/*}}}*/
/*FUNCTION DoubleMatExternalResult::DeepEcho{{{1*/
void DoubleMatExternalResult::DeepEcho(void){

	int i;
	
	printf("DoubleMatExternalResult:\n");
	printf("   id: %i\n",this->id);
	printf("   enum: %i (%s)\n",this->enum_type,EnumAsString(this->enum_type));
	printf("   matrix size: %i-%i\n",this->M,this->N);
	for(i=0;i<this->M;i++){
		printf("%i %g\n",i,this->values[i]);
	}
	printf("   step: %i\n",this->step);
	printf("   time: %g\n",this->time);
}
/*}}}*/
/*FUNCTION DoubleMatExternalResult::Demarshall{{{1*/
void  DoubleMatExternalResult::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&id,marshalled_dataset,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*data: */
	memcpy(&M,marshalled_dataset,sizeof(M));marshalled_dataset+=sizeof(M);
	memcpy(&N,marshalled_dataset,sizeof(N));marshalled_dataset+=sizeof(N);
	values=(double*)xmalloc(M*N*sizeof(double));
	memcpy(values,marshalled_dataset,M*N*sizeof(double));marshalled_dataset+=M*N*sizeof(double);
	memcpy(&step,marshalled_dataset,sizeof(step));marshalled_dataset+=sizeof(step);
	memcpy(&time,marshalled_dataset,sizeof(time));marshalled_dataset+=sizeof(time);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION DoubleMatExternalResult::Echo {{{1*/
void DoubleMatExternalResult::Echo(void){

	printf("DoubleMatExternalResult:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumAsString(this->enum_type));
	printf("   matrix size: %i-%i\n",this->M,this->N);
	printf("   step: %i\n",this->step);
	printf("   time: %g\n",this->time);

}
/*}}}*/
/*FUNCTION DoubleMatExternalResult::Enum{{{1*/
int DoubleMatExternalResult::Enum(void){

	return DoubleMatExternalResultEnum;

}
/*}}}*/
/*FUNCTION DoubleMatExternalResult::Id{{{1*/
int    DoubleMatExternalResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DoubleMatExternalResult::Marshall{{{1*/
void  DoubleMatExternalResult::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of DoubleMatExternalResult: */
	enum_value=DoubleMatExternalResultEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall DoubleMatExternalResult data: */
	memcpy(marshalled_dataset,&id,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&M,sizeof(M));marshalled_dataset+=sizeof(M);
	memcpy(marshalled_dataset,&N,sizeof(N));marshalled_dataset+=sizeof(N);
	memcpy(marshalled_dataset,values,M*sizeof(double));marshalled_dataset+=M*sizeof(double);
	memcpy(marshalled_dataset,&step,sizeof(step));marshalled_dataset+=sizeof(step);
	memcpy(marshalled_dataset,&time,sizeof(time));marshalled_dataset+=sizeof(time);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION DoubleMatExternalResult::MarshallSize{{{1*/
int   DoubleMatExternalResult::MarshallSize(){
	
	return sizeof(M)
		+sizeof(N)
		+M*N*sizeof(double)
		+sizeof(id)
		+sizeof(enum_type)
		+sizeof(step)
		+sizeof(time)
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION DoubleMatExternalResult::MyRank{{{1*/
int    DoubleMatExternalResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/

/*Numerics: */
/*FUNCTION DoubleMatExternalResult::WriteData(FILE* fid) {{{1*/
void   DoubleMatExternalResult::WriteData(FILE* fid){

	int     length;
	int     type;
	int     size;
	char   *name    = NULL;
	extern  int my_rank;

	/*return if now on cpu 0: */
	if(my_rank)return;

	/*First write enum: */
	name=EnumAsString(this->enum_type);
	length=(strlen(name)+1)*sizeof(char);
	fwrite(&length,sizeof(int),1,fid);
	fwrite(name,length,1,fid);

	/*Now write time and step: */
	fwrite(&time,sizeof(double),1,fid);
	fwrite(&step,sizeof(int),1,fid);

	/*writing a double array, type is 3:*/
	type=3;
	size=this->M*this->N;
	fwrite(&type,sizeof(int),1,fid);
	fwrite(&size,sizeof(int),1,fid);
	fwrite(this->values,size*sizeof(double),1,fid);

}
/*}}}1*/
