/*!\file:  OutputResultsx.cpp
 * \brief: go through our finite elements, and see what results they have stored within. 
 * Then output them into serialized patch arrays, and dump to disk.
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "../../DataSet/DataSet.h"
#include "../../io/io.h"
#include "../../objects/objects.h"
		
void OutputResultsx(DataSet* elements, DataSet* loads, DataSet* nodes, DataSet* vertices, DataSet* materials, Parameters* parameters,DataSet* results){

	int         i;
	extern int  my_rank;
	char       *filename     = NULL;
	int         solutiontype;
	FILE       *fid          = NULL;

	/*First, configure elements*/
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Transfer element results into the femmodel->results dataset: */
	ElementResultsToPatch( elements,  loads,  nodes,  vertices,  materials, parameters,results);

	#ifdef _PARALLEL_
	/*Results do not include the type of solution being run	. In parallel, we output results to a filename, 
	 *therefore, we need to include the solutiontype into the filename: */
	parameters->FindParam(&solutiontype,SolutionTypeEnum);
	results->AddObject(new StringExternalResult(results->Size()+1,SolutionTypeEnum,EnumAsString(solutiontype),1,0));
	#endif

	//Recover file name: 
	parameters->FindParam(&filename,OutputFileNameEnum);

	//Open filename for writing only on cpu 0
	if(my_rank==0)fid=pfopen(filename,"wb");

	for(i=0;i<results->Size();i++){
		ExternalResult* result=(ExternalResult*)results->GetObjectByOffset(i);

		/*write result to disk: */
		result->WriteData(fid);
	}

	/*Close file: */
	if(my_rank==0)pfclose(fid,filename);

	/*Free ressources:*/
	xfree((void**)&filename);
}
