/*!\file VerticesDofx
 * \brief: establish degrees of freedom for all vertices, and return partitioning vector. Do only once.
 */

#include "./VerticesDofx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void VerticesDofx( DofVec** ppartition, DofVec** ptpartition, DataSet* vertices, Parameters* parameters) {

	int i;

	int  found=0;
	extern int num_procs;
	extern int my_rank;
	
	/*intermediary: */
	int  numberofvertices;

	/*output: */
	DofVec* partition=NULL;
	DofVec* tpartition=NULL;

	if(*ppartition) return; //do not create partition vector twice! we only have on set of vertices

	/*Initialize dofvecs: */
	partition=new  DofVec("partition");
	tpartition=new DofVec("tpartition");

	/*First, recover number of vertices and nodes from parameters: */
	found=parameters->FindParam(&numberofvertices,NumberOfVerticesEnum);
	if(!found)ISSMERROR(" could not find numberofvertices in parameters");
	
	/*Ensure that only for each cpu, the partition border vertices only will be taken into account once 
	 * across the cluster. To do so, we flag all the clone vertices: */
	vertices->FlagClones(numberofvertices);

	/*Go through all vertices and distribute 1 dof at a time. When a  vertex has already been distributed his dof on a cpu, 
	 * all other cpus with the same vertex cannot distribute it anymore. Use clone field to be sure of that: */
	vertices->DistributeDofs(numberofvertices,1); //only 1 dof per vertex.

	/*Now that dofs have been distributed, create partitioning vector and its transpose: */
	vertices->CreatePartitioningVector(&partition->vector,numberofvertices);

	/*Transpose partition into tpartition: */
	VecTranspose(&tpartition->vector,partition->vector);

	/*Now, setup numdof and numentries for dofvec: */
	partition->numdofs=1;
	VecGetSize(partition->vector,&partition->numentries);

	tpartition->numdofs=1;
	VecGetSize(tpartition->vector,&tpartition->numentries);

	/*Assign output pointers: */
	*ppartition=partition;
	*ptpartition=tpartition;
	
}
