function femmodel=surfaceslope_core(femmodel)
%SURFACESLOPE_CORE - core of the surface slope computation solution
%
%   Usage:
%      femmodel=surfaceslope_core(femmodel)
%

	%Recover some parameters:
	verbose=femmodel.parameters.Verbose;
	dim=femmodel.parameters.Dim;

	displaystring(verbose,'\n%s',['computing surface slope...']);

	%Call on core computations: 
	femmodel=SetCurrentAnalysisAlias(femmodel,SlopeAnalysisEnum,SurfaceSlopeXAnalysisEnum);
	femmodel=solver_linear(femmodel);
	femmodel=SetCurrentAnalysisAlias(femmodel,SlopeAnalysisEnum,SurfaceSlopeYAnalysisEnum);
	femmodel=solver_linear(femmodel);
	
	%extrude inputs if we are in 3D: */
	if dim==3,
		displaystring(verbose,'\n%s',['extruding surface slopein 3d...']);
		femmodel.elements=InputExtrude(femmodel.elements,femmodel.nodes, femmodel.vertices,femmodel.loads, femmodel.materials,femmodel.parameters,SurfaceSlopeXEnum);
		femmodel.elements=InputExtrude(femmodel.elements,femmodel.nodes, femmodel.vertices,femmodel.loads, femmodel.materials,femmodel.parameters,SurfaceSlopeYEnum);
	}
	
	displaystring(verbose,'\n%s',['saving results...']);
	femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,SurfaceSlopeXEnum);
	femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,SurfaceSlopeYEnum);

end %end function
