function femmodel=prognostic_core(femmodel)
%PROGNOSTIC_CORE - linear solution sequence
%
%   Usage:
%      femmodel=prognostic_core(femmodel)

	%recover parameters common to all solutions
	verbose=femmodel.parameters.Verbose;

	%Activate formulation
	femmodel=SetCurrentAnalysis(femmodel,PrognosticAnalysisEnum);

	displaystring(verbose,'\n%s',['depth averaging velocities...']);
	[femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters]=InputDepthAverage(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VxEnum,VxAverageEnum);
	[femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters]=InputDepthAverage(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VyEnum,VyAverageEnum);

	displaystring(verbose,'\n%s',['call computational core...']);
	femmodel=solver_linear(femmodel);
	
	displaystring(verbose,'\n%s',['extude computed thickness on all layers...']);
	femmodel.elements=InputExtrude(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,ThicknessEnum);

	displaystring(verbose,'\n%s',['saving results...']);
	femmodel.elements=InputToResult(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,ThicknessEnum);

end %end function
