function femmodel=controlrestart(femmodel,J)
%CONTROLRESTART - save as much as possible to be able to restart the control_core solution
%
%   Usage:
%       femmodel=controlrestart(femmodel,J);

	%recover parameters common to all solutions
	nsteps=femmodel.parameters.NSteps;
	control_type=femmodel.parameters.ControlType;
	
	%Save J and the parameter
	InputToResult(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel.parameters,control_type);
	femmodel.results.JEnum=J;
	femmodel.results.ControlTypeEnum=EnumAsString(control_type);

	%Write to disk
	OutputResults(femmodel.elements, femmodel.loads, femmodel.nodes, femmodel.vertices, femmodel.materials, femmodel.parameters);

end %end function
