function md=transient2d(md);
%TRANSIENT2D - 2d transient solution
%
%   Usage:
%      md=transient(md)
%
%   See also: TRANSIENT3D, TRANSIENT

	analysis_types=[DiagnosticHorizAnalysisEnum,PrognosticAnalysisEnum];
	solution_type=Transient2DAnalysisEnum;

	displaystring(md.verbose,'%s',['create finite element model']);
	femmodel=NewFemModel(md,solution_type,analysis_types,2);

	%retrieve parameters
	verbose=femmodel.parameters.Verbose;
	qmu_analysis=femmodel.parameters.QmuAnalysis;

	%compute solution
	if ~qmu_analysis,
		displaystring(verbose,'%s',['call computational core']);
		femmodel=transient2d_core(femmodel);
		
		displaystring(verbose,'%s',['write results']);
		OutputResults(femmodel.elements, femmodel.loads, femmodel.nodes, femmodel.vertices, femmodel.materials, femmodel.parameters);

	else
		%launch dakota driver for diagnostic core solution
		Qmu(femmodel);
	end

	%stop timing
	t2=clock;
	displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);
