function models=ControlInitialization(models);

%recover models
m_dh=models.dh;
m_dv=models.dv;
m_ds=models.ds;
m_dhu=models.dhu;
m_sl=models.sl;

%recover parameters common to all solutions
verbose=m_dhu.parameters.verbose;
dim=m_dhu.parameters.dim;
ishutter=m_dhu.parameters.ishutter;
ismacayealpattyn=m_dh.parameters.ismacayealpattyn;
isstokes=m_ds.parameters.isstokes;

%If Pattyn or MacAyeal, just return, no initialization needed
if ~isstokes
	models.active=m_dh;
	return
end

%1: Get slopes once for all

%compute slopes
displaystring(verbose,'\n%s',['computing bed slope (x and y derivatives)...']);
slopex=diagnostic_core_linear(m_sl,SlopecomputeAnalysisEnum(),BedXAnalysisEnum());
slopey=diagnostic_core_linear(m_sl,SlopecomputeAnalysisEnum(),BedYAnalysisEnum());
slopex=FieldExtrude(m_sl.elements,m_sl.nodes,m_sl.vertices,m_sl.loads,m_sl.materials,m_sl.parameters,slopex,'slopex',0);
slopey=FieldExtrude(m_sl.elements,m_sl.nodes,m_sl.vertices,m_sl.loads,m_sl.materials,m_sl.parameters,slopey,'slopey',0);

%Add to inputs
inputs=add(inputs,'bedslopex',slopex,'doublevec',m_sl.parameters.numberofdofspernode,m_sl.parameters.numberofnodes);
inputs=add(inputs,'bedslopey',slopey,'doublevec',m_sl.parameters.numberofdofspernode,m_sl.parameters.numberofnodes);

%2: update spcs using MacAyeal or Pattyn

%horizontal velocities
displaystring(verbose,'\n%s',['computing horizontal velocities...']);
u_g=diagnostic_core_nonlinear(m_dh,DiagnosticAnalysisEnum(),HorizAnalysisEnum());
displaystring(verbose,'\n%s',['extruding horizontal velocities...']);
u_g_horiz=FieldExtrude(m_dh.elements,m_dh.nodes,m_dh.vertices,m_dh.loads,m_dh.materials,m_dh.parameters,u_g,'velocity',1);

%vertical velocities
displaystring(verbose,'\n%s',['computing vertical velocities...']);
inputs=add(inputs,'velocity',u_g_horiz,'doublevec',m_dh.parameters.numberofdofspernode,m_dh.parameters.numberofnodes);
u_g_vert=diagnostic_core_linear(m_dv,DiagnosticAnalysisEnum(),VertAnalysisEnum());

%create 3d u_g
displaystring(verbose,'\n%s',['combining horizontal and vertical velocities...']);
u_g=zeros(m_dh.parameters.numberofnodes*3,1);
u_g(dofsetgen([1,2],3,m_dh.parameters.numberofnodes*3))=u_g_horiz;
u_g(dofsetgen([3],3,m_dh.parameters.numberofnodes*3))=u_g_vert;

% get pressure (reconditionned) and create 4d u_g
displaystring(verbose,'\n%s',['computing pressure according to Pattyn...']);
p_g=ComputePressure(m_dh.elements,m_dh.nodes,mdh.vertices,m_dh.loads,m_dh.materials,m_dh.parameters,DiagnosticAnalysisEnum(),HorizAnalysisEnum());
p_g=p_g/m_ds.parameters.stokesreconditioning;
u_g_stokes=zeros(m_ds.nodesets.gsize,1);
u_g_stokes(dofsetgen([1,2,3],4,m_ds.nodesets.gsize))=u_g;
u_g_stokes(dofsetgen([4],4,m_ds.nodesets.gsize))=p_g;
inputs=add(inputs,'velocity',u_g_stokes,'doublevec',4,m_ds.parameters.numberofnodes);

%update BC (spcs)
displaystring(verbose,'\n%s',['update boundary conditions for stokes using velocities previously computed...']);
m_ds.y_g=zeros(m_ds.nodesets.gsize,1);
m_ds.y_g(dofsetgen([1,2,3],4,m_ds.nodesets.gsize))=u_g;
m_ds.ys=Reducevectorgtos(m_ds.y_g,m_ds.nodesets);

%Compute Stokes velocities once to have a reasonably good ug in input
displaystring(verbose,'\n%s',['computing stokes velocities and pressure ...']);
u_g=diagnostic_core_nonlinear(m_ds,DiagnosticAnalysisEnum(),StokesAnalysisEnum());
inputs=add(inputs,'velocity',u_g,'doublevec',4,m_ds.parameters.numberofnodes);

%assign output
models.active=m_ds;
