function dvar=setupdrag_node(dvar,variables,params,varargin)

for i=1:length(varargin)
    if strcmp(class(varargin{i}),'model')
        md=varargin{i};
        break;
    end
end

%first, recover  id of node: 
descriptor=variables.descriptor();
node=descriptor(10:end);

%this variable we are trying to setup for qmu analysis is shadowing 
%a variable in another pool of distributed variables. Ex: drag_node2 should 
%owershadow the drag2 parameter. So go through the dvars, and figure out 
%if the drag was already distributed. If not, error out. It so, then 
%plug drag_nodei variable into the i'th variable of the distributed drag.


found=0;
for i=1:numel(dvar),
	if strcmpi(dvar(i).descriptor,['drag' num2str(node)]),
		found=i;
		break;
	end
end
if found==0,
	error('setupdrag_node error message: could not find distributed drag parameters!');
end

%overshadow dvar(found) variable.
variables.descriptor=['drag' num2str(node)];
dvar(found)=variables;

