function dvar=setupthickness_node(dvar,variables,params,varargin)

for i=1:length(varargin)
    if strcmp(class(varargin{i}),'model')
        md=varargin{i};
        break;
    end
end

%first, recover  id of node: 
descriptor=variables.descriptor();
node=descriptor(15:end);

%this variable we are trying to setup for qmu analysis is shadowing 
%a variable in another pool of distributed variables. Ex: thickness_node2 should 
%owershadow the thickness2 parameter. So go through the dvars, and figure out 
%if the thickness was already distributed. If not, error out. It so, then 
%plug thickness_nodei variable into the i'th variable of the distributed thickness.


found=0;
for i=1:numel(dvar),
	if strcmpi(dvar(i).descriptor,['thickness' num2str(node)]),
		found=i;
		break;
	end
end
if found==0,
	error('setupthickness_node error message: could not find distributed thickness parameters!');
end

%overshadow dvar(found) variable.
variables.descriptor=['thickness' num2str(node)];
dvar(found)=variables;
