function md=process_qmu_response_data(md)
%PROCESS_QMU_RESPONSE_DATA - process any data necessary for the solutions to process the data. 
%
% Usage: md=process_qmu_response_data(md)
%
% See also PREQMU, PRESOLVE



for i=1:numel(md.responsedescriptors),
	if strcmpi(md.responsedescriptors{i},'mass_flux'),
		%we need a profile of points on which to compute the mass_flux, is it here? 
		if isnans(md.qmu_mass_flux_profile),
			error('process_qmu_response_data error message: could not find a mass_flux exp profile!');
		end
		if ~ischar(md.qmu_mass_flux_profile),
			error('process_qmu_response_data error message: mass_flux exp profile should be a domain outline name');
		end
		%ok, process the qmu_mass_flux_profile to build a list of segments: 
		md.qmu_mass_flux_segments=MassFluxProcessProfile(md);
	end
end
