function md=balancedthickness2(md)
%BALANCEDTHICKNESS - balancedthickness2 solution sequence.
%
%   Usage:
%      md=balancedthickness2(md)

	analysis_types=[Balancedthickness2AnalysisEnum];
	solution_type=Balancedthickness2AnalysisEnum;

	displaystring(md.verbose,'%s',['create finite element model']);
	femmodel=NewFemModel(md,solution_type,analysis_types,1);

	%retrieve parameters
	verbose=femmodel.parameters.Verbose;
	qmu_analysis=femmodel.parameters.QmuAnalysis;

	%compute solution
	if ~qmu_analysis,
		displaystring(verbose,'%s',['call computational core']);
		balancedthickness2_core(femmodel);
	else
		%launch dakota driver for diagnostic core solution
		Qmu(femmodel);
	end

	%stop timing
	t2=clock;
	displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);
