function femmodel=NewFemModel(md,solution_type,analysis_types);
%NEWFEMMODEL - create a finite element model out of the matlab base \@model md. 
%   For each analysis_type contained in analysis_types, create a set of nodes, constraints 
%   and loads. All analyses rely on the same elements, vertices and parameters. See 
%   FemModel.cpp in src/c/objects for more information on the FemModel implementation in c++
%
%   Usage:
%      femmodel=NewFemModel(md,solution_type,analysis_types)
%


   femmodel.solution_type=solution_type;
   femmodel.analysis_counter=nummodels; %point to last analysis_type carried out

   %Dynamically allocate whatever is a list of length nummodels: */
   femmodel.analysis_type_list=analysis_types;

   displaystring(md.verbose,'\n   reading data from model %s...',md.name);
   [femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.constraints,femmodel.loads,femmodel.materials,femmodel.parameters]=ModelProcessor(md,solution_type,femmodel.analysis_type_list);

   %now, go through all analyses types and post-process datasets
   for i=1:length(analysis_types),
	   
	   analysis_type=femmodel.analysis_type_list(i);
	   displaystring(md.verbose,'%s%s','   dealing with analysis type: ',EnumAsString(analysis_type);

	   displaystring(md.verbose,'%s','      generating degrees of freedofemmodel...');
	   if ~isfield(femmodel,'part') [femmodel.vertices,femmodel.part,femmodel.tpart]=VerticesDof(vertices, femmodel.parameters); %do not create partition vector twice! we only have one set of vertices!
		   
		   [femmodel.nodes]=NodesDof(femmodel.nodes,femmodel.parameters);

		   displaystring(md.verbose,'%s','      generating single point constraints...');
		   [femmodel.nodes,femmodel.m_yg(i)]=SpcNodes(femmodel.nodes,femmodel.constraints,analysis_type);

		   displaystring(md.verbose,'%s','      generating rigid body constraints...');
		   [femmodel.m_Rmg(i),femmodel.nodes]=MpcNodes(femmodel.nodes,femmodel.constraints,analysis_types);

		   displaystring(md.verbose,'%s','      generating node sets...');
		   femmodel.m_nodesets(i)=BuildNodeSets(femmodel.nodes,analysis_type);

		   displaystring(md.verbose,'%s','      reducing single point constraints vector...');
		   femmodel.m_ys(i)=Reducevectorgtos(femmodel.m_yg(i).vector,femmodel.m_nodesets(i));

		   displaystring(md.verbose,'%s','      normalizing rigid body constraints matrix...');
		   femmodel.m_Gmn(i)= NormalizeConstraints(femmodel.m_Rmg(i),femmodel.m_nodesets(i));

		   displaystring(md.verbose,'%s','      configuring element and loads...');
		   [femmodel.elements,femmodel.loads,femmodel.nodes,femmodel.parameters] = ConfigureObjects( femmodel.elements, femmodel.loads, femmodel.nodes, femmodel.vertices,femmodel.materials,femmodel.parameters);
	   end
   end
