function femmodel=SetCurrentAnalysisAlias(femmodel,base_analysis_enum,real_analysis_type)
%SETCURRENTANALYSISALIAS- set current analysis used to configure elements and nodes in our solutions, 
%   and use  another analysis_type instead.
%
%   Usage:
%      femmodel=SetCurrentAnalysisAlias(femmodel,base_analysis_type,real_analysis_type)
%
%   Ex:
%      femmodel=SetCurrentAnalysis(femmodel,DiagnosticHorizAnalysisEnum,AdjointAnalysisEnum)
%


	%first, look for analysis: 
	int found=0;
	for i=1:length(femmodel.analysis_type_list),
		if analysis_type_list(i)==base_analysis_enum,
			found=i;
			break;
	end

	if (found!=1),
		error('SetCurrentAnalysisAlias error message: could not find analysis_type in list of FemModel analyses');
	end

	
	%activate matrices and vectors: 
	femmodel.Rmg=femmodel.m_Rmg(found);
	femmodel.Gmn=femmodel.m_Gmn(found);
	femmodel.nodesets=femmodel.m_nodesets(found);
	femmodel.yg=femmodel.m_yg(found);
	femmodel.ys=femmodel.m_ys(found);


	%Now, plug analysis_counter and analysis_type inside the parameters: 
	%set counter and analyse_type
	femmodel.parameters.AnalysisCounter=found;
	femmodel.parameters.AnalysisType=real_analysis_type;
