function femmodel=bedslope_core(femmodel)
%SURFACESLOPE_CORE - core of the bed slope computation solution
%
%   Usage:
%      femmodel=bedslope_core(femmodel)
%


	%Recover some parameters:
	verbose=femmodel.parameters.Verbose;
	dim=femmodel.parameters.Dim;

	displaystring(verbose,'\n%s',['computing bed slope...']);

	%Call on core computations: 
	femmodel=SetCurrentAnalysisAlias(femmodel,SlopeAnalysisEnum,SurfaceSlopeXAnalysisEnum);
	femmodel=solver_linear(femmodel);
	femmodel=SetCurrentAnalysisAlias(femmodel,SlopeAnalysisEnum,SurfaceSlopeYAnalysisEnum);
	femmodel=solver_linear(femmodel);
	
	%extrude inputs if we are in 3D: */
	if dim==3,
		displaystring(verbose,'\n%s',['extruding bed slopein 3d...']);
		InputExtrude(femmodel.elements,femmodel.nodes, femmodel.vertices,femmodel.loads, femmodel.materials,femmodel.parameters,SurfaceSlopeXEnum);
		InputExtrude(femmodel.elements,femmodel.nodes, femmodel.vertices,femmodel.loads, femmodel.materials,femmodel.parameters,SurfaceSlopeYEnum);
	}
	
	displaystring(verbose,'\n%s',['saving results...']);
	InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,SurfaceSlopeXEnum);
	InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,SurfaceSlopeYEnum);
