/*\file UpdateGeometry.c
*\brief: update geometry after prognostic computation of new thickness
*/

#include "./UpdateGeometry.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

/*diverse: */
int         noerr             = 1;

/*input datasets: */
DataSet    *elements          = NULL;
DataSet    *nodes             = NULL;
DataSet    *vertices          = NULL;
DataSet    *loads             = NULL;
DataSet    *materials         = NULL;
Parameters *parameters        = NULL;

/*Boot module: */
MODULEBOOT();

/*checks on arguments on the matlab side: */
CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&UpdateGeometryUsage);

/*Input datasets: */
FetchData(&elements,ELEMENTSIN);
FetchData(&nodes,NODESIN);
FetchData(&vertices,VERTICESIN);
FetchData(&loads,LOADSIN);
FetchData(&materials,MATERIALSIN);
FetchParams(&parameters,PARAMETERSIN);

/*call "x" code layer*/
UpdateGeometryx(elements,nodes,vertices,loads, materials,parameters);

/*write output datasets: */
WriteData(ELEMENTS,elements);
WriteData(NODES,nodes);
WriteData(VERTICES,vertices);
WriteData(LOADS,loads);
WriteData(MATERIALS,materials);
WriteParams(PARAMETERS,parameters);

/*Free ressources: */
delete elements;
delete nodes;
delete vertices;
delete loads;
delete materials;
delete parameters;

/*end module: */
MODULEEND();
}

void UpdateGeometryUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements,nodes,vertices,loads,materials,parameters] = %s(elements,nodes,vertices,loads,materials,parameters);\n",__FUNCT__);
	_printf_("\n");
}
