/*\file SystemMatrices.c
 *\brief: build system matrices (stiffness matrix, loads vector)
 */

#include "./SystemMatrices.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* vertices=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	Parameters* parameters=NULL;
	int         kflag,pflag;
	
	/* output datasets: */
	Mat Kgg=NULL;
	Vec pg=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&SystemMatricesUsage);

	/*Input datasets: */
	FetchData(&elements,ELEMENTS);
	FetchData(&nodes,NODES);
	FetchData(&vertices,VERTICES);
	FetchData(&loads,LOADS);
	FetchData(&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);

	/*parameters: */
	parameters->FindParam(&kflag,KflagEnum);
	parameters->FindParam(&pflag,PflagEnum);

	/*!Generate internal degree of freedom numbers: */
	SystemMatricesx(&Kgg, &pg,elements,nodes,vertices,loads,materials,parameters,kflag,pflag);

	/*write output datasets: */
	WriteData(KGG,Kgg);
	WriteData(PG,pg);
	
	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	MatFree(&Kgg);
	VecFree(&pg);

	/*end module: */
	MODULEEND();
}

void SystemMatricesUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [Kgg,pg] = %s(elements,nodes,vertices,loads,materials,parameters);\n",__FUNCT__);
	_printf_("\n");
}
