/*\file Gradj.c
 *\brief: compute gradients for inverse control method
 */

#include "./Gradj.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int         noerr        = 1;

	/*input datasets: */
	DataSet    *elements     = NULL;
	DataSet    *nodes        = NULL;
	DataSet    *vertices     = NULL;
	DataSet    *loads        = NULL;
	DataSet    *materials    = NULL;
	Parameters *parameters   = NULL;
	int         control_type;

	/* output datasets: */
	Vec         grad_g       = NULL;


	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&GradjUsage);

	/*Input datasets: */
	FetchData(&elements,ELEMENTS);
	FetchData(&nodes,NODES);
	FetchData(&vertices,VERTICES);
	FetchData(&loads,LOADS);
	FetchData(&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	parameters->FindParam(&control_type,ControlTypeEnum);

	/*!Call core code: */
	Gradjx(&grad_g,elements,nodes,vertices,loads,materials,parameters,control_type);

	/*write output : */
	WriteData(GRADG,grad_g);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	VecFree(&grad_g);

	/*end module: */
	MODULEEND();
}

void GradjUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [grad_g] = %s(elements,nodes,vertices,loads, materials, parameters);\n",__FUNCT__);
	_printf_("\n");
}
