function md=steadystate(md);
%STEADYSTATE - compute the velocity and temperature field of a model in steady state.
%
%   Usage:
%      md=steadystate(md)
%

	%timing
	t1=clock;

	analysis_types=[DiagnosticHorizAnalysisEnum,DiagnosticVertAnalysisEnum,DiagnosticStokesAnalysisEnum,DiagnosticHutterAnalysisEnum,SlopeAnalysisEnum,ThermalAnalysisEnum,MeltingAnalysisEnum];
	solution_type=SteadyStateAnalysisEnum;

	displaystring(md.verbose,'%s',['create finite element model']);
	femmodel=NewFemModel(md,solution_type,analysis_types);

	%retrieve parameters
	verbose=femmodel.parameters.Verbose;
	qmu_analysis=femmodel.parameters.QmuAnalysis;
	control_analysis=femmodel.parameters.ControlAnalysis;
	
	%compute solution
	if ~qmu_analysis,
		if ~control_analysis,
			
			displaystring(verbose,'%s',['call computational core']);
			steadystate_core(femmodel);

		else,
			
			displaystring(verbose,'%s',['call computational core']);
			control_core(femmodel);

		end
	else
		%launch dakota driver for diagnostic core solution
		Qmu(femmodel);
	end

	%stop timing
	t2=clock;
	displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);
