/*\file ExtrudeInput.c
 *\brief: extrude input vertically
 */

#include "./ExtrudeInput.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* vertices=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	Parameters* parameters=NULL;
	int      NameEnum;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ExtrudeInputUsage);

	/*Input datasets: */
	FetchData(&elements,ELEMENTS);
	FetchData(&nodes,NODES);
	FetchData(&vertices,VERTICES);
	FetchData(&loads,LOADS);
	FetchData(&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	FetchData(&NameEnum,NAME);

	/*!Call core code: */
	ExtrudeInputx(elements,nodes,vertices,loads,materials,parameters,NameEnum);

	/*write output : */
	WriteData(ELEMENTSOUT,elements);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	
	/*end module: */
	MODULEEND();

}

void ExtrudeInputUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements] = %s(elements, nodes, vertices, loads, materials, parameters, name_enum);\n",__FUNCT__);
	_printf_("\n");
}
