/*!\file:  Material.h
 * \brief abstract class for Material object
 */ 


#ifndef _MATERIAL_H_
#define _MATERIAL_H_

/*Headers:*/
/*{{{1*/
class Object;
#include "../Object.h"
#include "../../toolkits/toolkits.h"
/*}}}*/

class Material: public Object{

	public: 
		virtual       ~Material(){};
		virtual void  Echo()=0;
		virtual void  DeepEcho()=0;
		virtual int   Id()=0;
		virtual int   MyRank()=0;
		virtual void  Marshall(char** pmarshalled_dataset)=0;
		virtual int   MarshallSize()=0;
		virtual void  Demarshall(char** pmarshalled_dataset)=0;
		virtual void  UpdateFromInputs(void* inputs)=0;
		virtual void  InputUpdateFromVector(double* vector, int name, int type)=0;
		virtual void  InputUpdateFromVector(int* vector, int name, int type)=0;
		virtual void  InputUpdateFromVector(bool* vector, int name, int type)=0;
		virtual void  InputUpdateFromSolution(double* solution)=0;
		
};
#endif
