/*! \file TriaVertexElementResult.h 
 *  \brief: header file for triavertexresult object
 */


#ifndef _TRIAVERTEXELEMENTRESULT_H_
#define _TRIAVERTEXELEMENTRESULT_H_

/*Headers:*/
/*{{{1*/
#include "../Inputs/Input.h"
#include "../../include/include.h"
/*}}}*/

class TriaVertexElementResult: public TriaVertexInput,public ElementResult{

	private: 
		int    step;
		double time;

	public:

		/*constructors, destructors: {{{1*/
		TriaVertexElementResult();
		TriaVertexElementResult(int enum_type,double* values,int step,double time);
		~TriaVertexElementResult();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();
		
		void    InputUpdateFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromSolution(double* solution, int analysis_type, int sub_analysis_type){ISSMERROR("Not implemented yet!");}

		/*}}}*/
		/*result virtual functions: {{{1*/
		ElementResult* SpawnSingElementResult(int  index);
		ElementResult* SpawnBeamElementResult(int* indices);
		ElementResult* SpawnTriaElementResult(int* indices);
		void    ProcessUnits(Parameters* parameters);
		int     NumberOfNodalValues(void);
		void    PatchFill(int row, Patch* patch);
		/*}}}*/

};
#endif  /* _TRIAVERTEXELEMENTRESULT_H */
