/*!\file Spc.h
 * \brief: header file for spc object
 */

#ifndef _SPC_H_
#define _SPC_H_

/*Headers:*/
/*{{{1*/
#include "../Object.h"
class DataSet;
/*}}}*/

class Spc: public Object{

	private: 
		int	sid; /*! id, to track it*/
		int	nodeid; /*!node id*/
		int dof; /*!component*/
		double value; /*value*/
		int analysis_type;

	public:

		Spc();
		Spc(int sid,int nodeid, int dof,double value,int analysis_type);
		~Spc();

		void   Echo();
		void   DeepEcho();
		void   Marshall(char** pmarshalled_dataset);
		int    MarshallSize();
		void   Demarshall(char** pmarshalled_dataset);
		int    Enum();
		int    Id(); 
		int    MyRank();
		int    GetNodeId();
		int    GetDof();
		double GetValue();
		Object* copy();
		void    InputUpdateFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromSolution(double* solution){ISSMERROR("Not implemented yet!");}
		bool    InAnalysis(int analysis_type);



};

#endif  /* _SPC_H_ */
