/*!\file:  gradient_core.cpp
 * \brief compute inverse method gradient direction.
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../include/include.h"
#include "../solvers/solvers.h"


void gradient_core(FemModel* femmodel,int step, double search_scalar){ //step defaults to 0, search_scalar defaults to 0
	
	/*parameters: */
	int control_steady;
	int control_type;
	int verbose;
	Vec new_gradient=NULL;
	Vec gradient=NULL;
	Vec old_gradient=NULL;

	/*retrieve parameters:*/
	femmodel->parameters->FindParam(&control_steady,ControlSteadyEnum);
	femmodel->parameters->FindParam(&control_type,ControlTypeEnum);
	femmodel->parameters->FindParam(&verbose,VerboseEnum);

	if(verbose)_printf_("%s\n","      compute adjoint state:");
	adjoint_core(femmodel);
	
	if(verbose)_printf_("%s\n","      compute gradient:");
	Gradjx(&gradient, femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,femmodel->parameters, control_type);
	
	if(verbose)_printf_("%s\n","      retrieve old gradient:");
	GetVectorFromInputsx(&old_gradient, femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,femmodel->parameters, OldGradientEnum,VertexEnum);

	if(control_steady)diagnostic_core(femmodel);
	
	if (step>0 && search_scalar==0){
		_printf_("%s","      orthogonalization...");
		Orthx(&new_gradient,gradient,old_gradient);
	}
	else{ 
		_printf_("%s","      normalizing directions...");
		Orthx(&new_gradient,gradient,NULL);
	}
	_printf_("%s\n"," done.");

	
	/*point gradient and old_gradient to new_gradient: */
	VecFree(&gradient); gradient=new_gradient;
	VecFree(&old_gradient); old_gradient=new_gradient;

	/*plug back into inputs: */
	InputUpdateFromVectorx( femmodel-> elements,femmodel-> nodes, femmodel-> vertices,femmodel-> loads, femmodel-> materials,  femmodel->parameters,gradient,GradientEnum,VertexEnum);
	InputUpdateFromVectorx( femmodel-> elements,femmodel-> nodes, femmodel-> vertices,femmodel-> loads, femmodel-> materials,  femmodel->parameters,old_gradient,OldGradientEnum,VertexEnum);

	/*Free ressources and return:*/
	VecFree(&new_gradient);
}
