/*! \file StringExternalResult.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _STRINGEXTERNALRESULT_H_
#define _STRINGEXTERNALRESULT_H_

/*Headers:*/
/*{{{1*/

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif


#include "./ExternalResult.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../include/include.h"
/*}}}*/

class StringExternalResult: public ExternalResult{

	private: 
		int    id;
		int    enum_type;
		char*  value;
		int    step;
		double time;

	public:
		/*constructors, destructors: {{{1*/
		StringExternalResult();
		StringExternalResult(int id,int enum_type,char* value,int step, double time);
		~StringExternalResult();
		/*}}}*/
		/*Object methods: {{{1*/
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();

		void  InputUpdateFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromSolution(double* solution){ISSMERROR("Not implemented yet!");}
		/*}}}*/
		/*ExternalResult methods: {{{1*/
		int   EnumType(){return enum_type;}
		/*}}}*/
};
#endif  /* _STRINGEXTERNALRESULT_H */
