/*!\file InputUpdateFromVectorx
 * \brief: update datasets using  parameter inputs
 */

#include "./InputUpdateFromVectorx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void InputUpdateFromVectorx( DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,Vec vector, int NameEnum, int TypeEnum){

	double* serial_vector=NULL;

	VecToMPISerial(&serial_vector,vector);

	InputUpdateFromVectorx( elements,nodes, vertices, loads, materials, parameters,serial_vector,NameEnum, TypeEnum);

	/*Free ressources:*/
	xfree((void**)&serial_vector);
}

	
void InputUpdateFromVectorx( DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,double* vector, int NameEnum, int TypeEnum){

	int i;

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->Configure(elements, loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements, loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Update elements, nodes, loads and materials from inputs: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<nodes->Size();i++){
		Node* node=(Node*)nodes->GetObjectByOffset(i);
		node->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<vertices->Size();i++){
		Vertex* vertex=(Vertex*)vertices->GetObjectByOffset(i);
		vertex->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<loads->Size();i++){
		Load* load=(Load*)loads->GetObjectByOffset(i);
		load->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<materials->Size();i++){
		Material* material=(Material*)materials->GetObjectByOffset(i);
		material->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<parameters->Size();i++){
		Param* parameter=(Param*)parameters->GetObjectByOffset(i);
		parameter->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}

}

void InputUpdateFromVectorx( DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,int* vector, int NameEnum, int TypeEnum){
	
	int i;

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->Configure(elements, loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements, loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Update elements, nodes, loads and materials from inputs: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<nodes->Size();i++){
		Node* node=(Node*)nodes->GetObjectByOffset(i);
		node->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<vertices->Size();i++){
		Vertex* vertex=(Vertex*)vertices->GetObjectByOffset(i);
		vertex->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<loads->Size();i++){
		Load* load=(Load*)loads->GetObjectByOffset(i);
		load->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<materials->Size();i++){
		Material* material=(Material*)materials->GetObjectByOffset(i);
		material->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<parameters->Size();i++){
		Param* parameter=(Param*)parameters->GetObjectByOffset(i);
		parameter->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}

}

void InputUpdateFromVectorx( DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,bool* vector, int NameEnum, int TypeEnum){

	int i;

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->Configure(elements, loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements, loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Update elements, nodes, loads and materials from inputs: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<nodes->Size();i++){
		Node* node=(Node*)nodes->GetObjectByOffset(i);
		node->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<vertices->Size();i++){
		Vertex* vertex=(Vertex*)vertices->GetObjectByOffset(i);
		vertex->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<loads->Size();i++){
		Load* load=(Load*)loads->GetObjectByOffset(i);
		load->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<materials->Size();i++){
		Material* material=(Material*)materials->GetObjectByOffset(i);
		material->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<parameters->Size();i++){
		Param* parameter=(Param*)parameters->GetObjectByOffset(i);
		parameter->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
}
