/*! \file StringArrayParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _STRINGARRAYPARAM_H_
#define _STRINGARRAYPARAM_H_

/*Headers:*/
/*{{{1*/

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif


#include "./Param.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../include/include.h"
/*}}}*/

class StringArrayParam: public Param{

	private: 
		/*just hold 3 values for 3 vertices: */
		int      enum_type;
		char**   value;
		int      numstrings;


	public:
		/*constructors, destructors: {{{1*/
		StringArrayParam();
		StringArrayParam(int enum_type,char** values, int numstrings);
		~StringArrayParam();
		/*}}}*/
		/*Object methods: {{{1*/
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		void  UpdateInputsFromVector(double* vector, int name, int type);
		void  UpdateInputsFromVector(int* vector, int name, int type);
		void  UpdateInputsFromVector(bool* vector, int name, int type);
		void  InputUpdateFromConstant(double constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromSolution(double* solution){ISSMERROR("Not implemented yet!");}

		/*}}}*/
		/*Param methods: {{{1*/
		int   EnumType(){return enum_type;}
		void  GetParameterValue(bool* pbool){ISSMERROR("StringArray param of enum %i (%s) cannot return a bool",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(int* pinteger){ISSMERROR("StringArray param of enum %i (%s) cannot return an integer",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(double* pdouble){ISSMERROR("StringArray param of enum %i (%s) cannot return a double",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(char** pstring){ISSMERROR("StringArray param of enum %i (%s) cannot return a string",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(char*** pstringarray,int* pM);
		void  GetParameterValue(double** pdoublearray,int* pM){ISSMERROR("StringArray param of enum %i (%s) cannot return a double array",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM, int* pN){ISSMERROR("StringArray param of enum %i (%s) cannot return a double array",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(Vec* pvec){ISSMERROR("StringArray param of enum %i (%s) cannot return a Vec",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(Mat* pmat){ISSMERROR("StringArray param of enum %i (%s) cannot return a Mat",enum_type,EnumAsString(enum_type));}

		void  SetValue(bool boolean){ISSMERROR("StringArray param of enum %i (%s) cannot hold a boolean",enum_type,EnumAsString(enum_type));}
		void  SetValue(int integer){ISSMERROR("StringArray param of enum %i (%s) cannot hold an integer",enum_type,EnumAsString(enum_type));}
		void  SetValue(double scalar){ISSMERROR("StringArray param of enum %i (%s) cannot hold a scalar",enum_type,EnumAsString(enum_type));}
		void  SetValue(char* string){ISSMERROR("StringArray param of enum %i (%s) cannot hold a string",enum_type,EnumAsString(enum_type));}
		void  SetValue(char** stringarray,int M);
		void  SetValue(double* doublearray,int M){ISSMERROR("StringArray param of enum %i (%s) cannot hold a double array",enum_type,EnumAsString(enum_type));}
		void  SetValue(double* pdoublearray,int M,int N){ISSMERROR("StringArray param of enum %i (%s) cannot hold a double array",enum_type,EnumAsString(enum_type));}
		void  SetValue(Vec vec){ISSMERROR("StringArray param of enum %i (%s) cannot hold a Vec",enum_type,EnumAsString(enum_type));}
		void  SetValue(Mat mat){ISSMERROR("StringArray param of enum %i (%s) cannot hold a Mat",enum_type,EnumAsString(enum_type));}

		char* GetParameterName(void);
		void  Process(double* partition,int numberofvertices);
		#ifdef _SERIAL_
		void  SetMatlabField(mxArray* dataref);
		#endif

		/*}}}*/
};
#endif  /* _STRINGARRAYPARAM_H */
