/*!\file Pengrid.h
 * \brief: header file for pengrid object */

#ifndef _PENGRID_H_
#define _PENGRID_H_

/*Headers:*/
/*{{{1*/
#include "./Load.h"
class Hook;
class Inputs;
class Parameters;
class IoModel;
/*}}}*/

class Pengrid: public Load{

	private: 

		int		id;
		int analysis_type;
		
		Hook hnode;  //hook to 1 node
		Hook helement;  //hook to 1 element
		Hook hmatpar; //hook to 1 matpar

		Parameters* parameters; //pointer to solution parameters
		Inputs*  inputs;
	
		/*internals: */
		int active;
		int zigzag_counter;

	public:

		/*FUNCTION constructors, destructors {{{1*/
		Pengrid();
		Pengrid(int index, int id, IoModel* iomodel,int analysis_type);
		~Pengrid();
		Object* copy();
		/*}}}*/
		/*FUNCTION object management {{{1*/
		void  Configure(DataSet* elementsin,DataSet* loadsin,DataSet* nodesin,DataSet* verticesin,DataSet* materialsin,Parameters* parametersin);
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		void  UpdateInputsFromVector(double* vector, int name, int type);
		void  UpdateInputsFromVector(int* vector, int name, int type);
		void  UpdateInputsFromVector(bool* vector, int name, int type);
		void  InputUpdateFromConstant(double constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromSolution(double* solution);
		bool  InAnalysis(int analysis_type);

		/*}}}*/
		/*FUNCTION element numerical routines {{{1*/
		void  CreateKMatrix(Mat Kgg);
		void  CreatePVector(Vec pg);
		void  PenaltyCreateKMatrix(Mat Kgg,double kmax);
		void  PenaltyCreatePVector(Vec pg,double kmax);
		void  PenaltyCreateKMatrixDiagnosticStokes(Mat Kgg,double kmax);
		void  GetDofList(int* doflist,int* pnumberofdofspernode);
		void  PenaltyCreateKMatrixThermal(Mat Kgg,double kmax);
		void  PenaltyCreateKMatrixMelting(Mat Kgg,double kmax);
		void  PenaltyCreatePVectorThermal(Vec pg, double kmax);
		void  PenaltyCreatePVectorMelting(Vec pg, double kmax);
		void  PenaltyConstrain(int* punstable);
		void  PenaltyConstrainThermal(int* punstable);
		
		/*updates:*/
		void  UpdateFromDakota(void* inputs);
		void  UpdateInputs(double* solution);
		/*}}}*/

};

#endif  /* _PENGRID_H_ */


