/*! \file BeamVertexInput.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _BEAMVERTEXINPUT_H_
#define _BEAMVERTEXINPUT_H_

/*Headers:*/
/*{{{1*/
#include "./Input.h"
/*}}}*/


class BeamVertexInput: public Input{

	public:
		/*just hold 2 values for 2 vertices: */
		int    enum_type;
		double values[2];

		/*constructors, destructors: {{{1*/
		BeamVertexInput();
		BeamVertexInput(int enum_type,double* values);
		~BeamVertexInput();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();
		void  UpdateInputsFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void  UpdateInputsFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void  UpdateInputsFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}

		void  InputUpdateFromSolution(double* solution){ISSMERROR("Not implemented yet!");}

		Input* SpawnSingInput(int  index);
		Input* SpawnBeamInput(int* indices);
		Input* SpawnTriaInput(int* indices);
		ElementResult* SpawnResult(int step, double time);

		/*}}}*/
		/*numerics: {{{1*/
		void GetParameterValue(bool* pvalue);
		void GetParameterValue(int* pvalue);
		void GetParameterValue(double* pvalue);
		void GetParameterValue(double* pvalue,Node* node);
		void GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord);
		void GetParameterValue(double* pvalue,double* gauss);
		void GetParameterValue(double* pvalue,double* gauss,double defaultvalue);
		
		void GetParameterAverage(double* pvalue);
	
		void GetParameterValues(double* values,double* gauss_pointers, int numgauss);
	
		void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss);
		void GetVxStrainRate2d(double* epsilonvx,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVyStrainRate2d(double* epsilonvy,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVxStrainRate3d(double* epsilonvx,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVyStrainRate3d(double* epsilonvy,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVzStrainRate3d(double* epsilonvz,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVxStrainRate3dPattyn(double* epsilonvx,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVyStrainRate3dPattyn(double* epsilonvy,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void ChangeEnum(int newenumtype);
		void SquareMin(double* psquaremin, bool process_units,Parameters* parameters);
		void Scale(double scale_factor);
		void AXPY(Input* xinput,double scalar);
		void Constrain(double cm_min, double cm_max);
		void GetVectorFromInputs(Vec vector,int* doflist);
		void GetValuesPtr(double** pvalues,int* pnum_values);
		/*}}}*/

};
#endif  /* _BEAMVERTEXINPUT_H */
