/*!\file InputUpdateFromSolutionx
 * \brief: update datasets using  parameter inputs
 */

#include "./InputUpdateFromSolutionx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void InputUpdateFromSolutionx( DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,Vec solution){

	double* serial_solution=NULL;

	/*Serialize solution, so that elements can index into it on every CPU: */
	VecToMPISerial(&serial_solution,solution);

	/*Call overloaded form of InputUpdateFromSolutionx: */
	InputUpdateFromSolutionx( elements, nodes,  vertices,  loads,  materials,  parameters,serial_solution);

	/*Free ressources:*/
	xfree((void**)&serial_solution);

}


void InputUpdateFromSolutionx( DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,double* solution){

	/*Intermediary*/
	int i;
	Element* element=NULL;

	/*First, get elements and loads configured: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);
	
	/*Elements drive the update: */
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->InputUpdateFromSolution(solution);
	}

}
