/*!\file Matpar.h
 * \brief: header file for matpar object
 */

#ifndef _MATPAR_H_
#define _MATPAR_H_

/*Headers:*/
/*{{{1*/
#include "./Material.h"
class IoModel;
/*}}}*/

class Matpar: public Material{

	private: 
		int	mid;
		double	rho_ice; 
		double	rho_water;
		double  heatcapacity;
		double  thermalconductivity;
		double  latentheat;
		double  beta;
		double  meltingpoint;
		double  mixed_layer_capacity;
		double  thermal_exchange_velocity;
		double  g;

	public:

		Matpar();
	
		Matpar(int	mid, double	rho_ice, double	rho_water, double  heatcapacity, double  thermalconductivity, double  latentheat, double  beta, double  meltingpoint, double  mixed_layer_capacity, double  thermal_exchange_velocity, double  g);
		void Init(int	mid, double	rho_ice, double	rho_water, double  heatcapacity, double  thermalconductivity, double  latentheat, double  beta, double  meltingpoint, double  mixed_layer_capacity, double  thermal_exchange_velocity, double  g);
		Matpar(int matpar_id, IoModel* iomodel);
		~Matpar();

		void  Echo();
		void  DeepEcho();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   Id(); 
		int   MyRank();
		void  UpdateFromInputs(void* inputs);
		double GetG();
		double GetRhoIce();
		double GetRhoWater();
		double GetMixedLayerCapacity();
		double GetThermalExchangeVelocity();
		double GetHeatCapacity();
		double GetThermalConductivity();
		double GetLatentHeat();
		double GetBeta();
		double GetMeltingPoint();
		Object* copy();
		void   UpdateInputsFromVector(double* vector, int name, int type);
		void   UpdateInputsFromVector(int* vector, int name, int type);
		void   UpdateInputsFromVector(bool* vector, int name, int type);
		void   InputUpdateFromConstant(double constant, int name);
		void   InputUpdateFromConstant(int constant, int name);
		void   InputUpdateFromConstant(bool constant, int name);
		void   UpdateInputsFromSolution(double* solution);


};

#endif  /* _MATPAR_H_ */
