/*! \file BeamVertexElementResult.h 
 *  \brief: header file for triavertexresult object
 */


#ifndef _BEAMVERTEXELEMENTRESULT_H_
#define _BEAMVERTEXELEMENTRESULT_H_

/*Headers:*/
/*{{{1*/
#include "../Inputs/Input.h"
#include "../../include/include.h"
/*}}}*/

class BeamVertexElementResult: public BeamVertexInput,public ElementResult{

	private: 
		int    step;
		double time;

	public:

		/*constructors, destructors: {{{1*/
		BeamVertexElementResult();
		BeamVertexElementResult(int enum_type,double* values,int step,double time);
		~BeamVertexElementResult();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();
		
		void    UpdateInputsFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type){ISSMERROR("Not implemented yet!");}

		/*}}}*/
		/*result virtual functions: {{{1*/
		ElementResult* SpawnSingElementResult(int  index){ISSMERROR("Not implemented yet!");}
		ElementResult* SpawnBeamElementResult(int* indices){ISSMERROR("Not implemented yet!");}
		ElementResult* SpawnTriaElementResult(int* indices){ISSMERROR("Not implemented yet!");}
		void    ProcessUnits(Parameters* parameters);
		int     NumberOfNodalValues(void);
		void    PatchFill(int row, Patch* patch);
		/*}}}*/

};
#endif  /* _BEAMVERTEXELEMENTRESULT_H */
