/*! \file DoubleVecParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _DOUBLEVECPARAM_H_
#define _DOUBLEVECPARAM_H_

/*Headers:*/
/*{{{1*/

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif


#include "./Param.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../include/include.h"
/*}}}*/

class DoubleVecParam: public Param{

	private: 
		int enum_type;
		IssmDouble* values;
		int M;

	public:
		/*constructors, destructors: {{{1*/
		DoubleVecParam();
		DoubleVecParam(int enum_type,IssmDouble* values,int M);
		~DoubleVecParam();
		/*}}}*/
		/*Object methods: {{{1*/
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		void  UpdateInputsFromVector(double* vector, int name, int type);
		void  UpdateInputsFromVector(int* vector, int name, int type);
		void  UpdateInputsFromVector(bool* vector, int name, int type);
		void  InputUpdateFromConstant(double constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);

		void  UpdateInputsFromSolution(double* solution){ISSMERROR("Not implemented yet!");}
		/*}}}*/
		/*Param methods: {{{1*/
		int   EnumType(){return enum_type;}
		void  GetParameterValue(bool* pbool){ISSMERROR("DoubleVec param of enum %i (%s) cannot return a bool",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(int* pinteger){ISSMERROR("DoubleVec param of enum %i (%s) cannot return an integer",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(double* pdouble){ISSMERROR("DoubleVec param of enum %i (%s) cannot return a double",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(char** pstring){ISSMERROR("DoubleVec param of enum %i (%s) cannot return a string",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(char*** pstringarray,int* pM){ISSMERROR("DoubleVec param of enum %i (%s) cannot return a string arrayl",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM);
		void  GetParameterValue(double** pdoublearray,int* pM, int* pN){ISSMERROR("DoubleVec param of enum %i (%s) cannot return a double array",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(Vec* pvec){ISSMERROR("DoubleVec param of enum %i (%s) cannot return a Vec",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(Mat* pmat){ISSMERROR("DoubleVec param of enum %i (%s) cannot return a Mat",enum_type,EnumAsString(enum_type));}

		void  SetValue(bool boolean){ISSMERROR("DoubleVec param of enum %i (%s) cannot hold a boolean",enum_type,EnumAsString(enum_type));}
		void  SetValue(int integer){ISSMERROR("DoubleVec param of enum %i (%s) cannot hold an integer",enum_type,EnumAsString(enum_type));}
		void  SetValue(double scalar){ISSMERROR("DoubleVec param of enum %i (%s) cannot hold a scalar",enum_type,EnumAsString(enum_type));}
		void  SetValue(char* string){ISSMERROR("DoubleVec param of enum %i (%s) cannot hold a string",enum_type,EnumAsString(enum_type));}
		void  SetValue(char** stringarray,int M){ISSMERROR("DoubleVec param of enum %i (%s) cannot hold a string array",enum_type,EnumAsString(enum_type));}
		void  SetValue(double* doublearray,int M);
		void  SetValue(double* pdoublearray,int M,int N){ISSMERROR("DoubleVec param of enum %i (%s) cannot hold a double mat array",enum_type,EnumAsString(enum_type));}
		void  SetValue(Vec vec){ISSMERROR("DoubleVec param of enum %i (%s) cannot hold a Vec",enum_type,EnumAsString(enum_type));}
		void  SetValue(Mat mat){ISSMERROR("DoubleVec param of enum %i (%s) cannot hold a Mat",enum_type,EnumAsString(enum_type));}

		char* GetParameterName(void);
		void  Process(double* partition,int numberofvertices);
		#ifdef _SERIAL_
		void  SetMatlabField(mxArray* dataref);
		#endif

		/*}}}*/
};
#endif  /* _DOUBLEVECPARAM_H */
