/*
 * Object.h:
 * \brief prototype for abstract Object class
 * \file Object.h
 * This prototype describes the Object class. This is an abstract class, parent 
 * to any other objects (Quad, Tria, Grid, etc ...), that can be included in a 
 * DataSet.
 */


#ifndef _OBJECT_H_
#define _OBJECT_H_

class Object {

	public: 
		virtual       ~Object() {};
		virtual void  Echo()=0;
		virtual void  DeepEcho()=0;
		virtual int   Id()=0;
		virtual int   MyRank()=0;
		virtual void  Marshall(char** pmarshalled_dataset)=0;
		virtual int   MarshallSize()=0;
		virtual void  Demarshall(char** pmarshalled_dataset)=0;
		virtual int   Enum()=0;
		virtual Object* copy()=0;
		virtual void  UpdateInputsFromVector(double* vector, int name, int type)=0;
		virtual void  UpdateInputsFromVector(int* vector, int name, int type)=0;
		virtual void  UpdateInputsFromVector(bool* vector, int name, int type)=0;
		virtual void  InputUpdateFromConstant(double constant, int name)=0;
		virtual void  InputUpdateFromConstant(int constant, int name)=0;
		virtual void  InputUpdateFromConstant(bool constant, int name)=0;
		virtual void  UpdateInputsFromSolution(double* solution)=0;
	
};
#endif
