/*! \file PentaVertexInput.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _PENTAVERTEXINPUT_H_
#define _PENTAVERTEXINPUT_H_

/*Headers:*/
/*{{{1*/
#include "./Input.h"
/*}}}*/

class PentaVertexInput: public Input{

	public:
		/*just hold 3 values for 3 vertices: */
		int    enum_type;
		double values[6];

		/*constructors, destructors: {{{1*/
		PentaVertexInput();
		PentaVertexInput(int enum_type,double* values);
		~PentaVertexInput();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();
		void    UpdateInputsFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}

		void    UpdateInputsFromSolution(double* solution){ISSMERROR("Not implemented yet!");}

		Input* SpawnSingInput(int  index);
		Input* SpawnBeamInput(int* indices);
		Input* SpawnTriaInput(int* indices);
		ElementResult* SpawnResult(int step, double time);

		/*}}}*/
		/*numerics: {{{1*/
		void GetParameterValue(bool* pvalue);
		void GetParameterValue(int* pvalue);
		void GetParameterValue(double* pvalue);
		void GetParameterValue(double* pvalue,Node* node);
		void GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord);
		void GetParameterValue(double* pvalue,double* gauss);
		void GetParameterValue(double* pvalue,double* gauss,double defaultvalue);
		
		void GetParameterAverage(double* pvalue);
		
		void GetParameterValues(double* values,double* gauss_pointers, int numgauss);
	
		void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss);
		void GetVxStrainRate2d(double* epsilonvx,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVyStrainRate2d(double* epsilonvy,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVxStrainRate3d(double* epsilonvx,double* xyz_list, double* gauss);
		void GetVyStrainRate3d(double* epsilonvy,double* xyz_list, double* gauss);
		void GetVzStrainRate3d(double* epsilonvz,double* xyz_list, double* gauss);
		void GetVxStrainRate3dPattyn(double* epsilonvx,double* xyz_list, double* gauss);
		void GetVyStrainRate3dPattyn(double* epsilonvy,double* xyz_list, double* gauss);
		void ChangeEnum(int newenumtype);
		void GetNodalFunctionsP1(double* l1l6, double* gauss_coord);
		void GetNodalFunctionsMINI(double* l1l7, double* gauss_coord);
		void GetNodalFunctionsP1Derivatives(double* dh1dh6,double* xyz_list, double* gauss_coord);
		void GetNodalFunctionsMINIDerivatives(double* dh1dh7,double* xyz_list, double* gauss_coord);
		void GetNodalFunctionsP1DerivativesReference(double* dl1dl6,double* gauss_coord);
		void GetNodalFunctionsMINIDerivativesReference(double* dl1dl7,double* gauss_coord);
		void GetJacobian(double* J, double* xyz_list,double* gauss_coord);
		void GetJacobianInvert(double*  Jinv, double* xyz_list,double* gauss_coord);
		void GetBPattyn(double* B, double* xyz_list, double* gauss_coord);
		void GetBStokes(double* B, double* xyz_list, double* gauss_coord);
		void SquareMin(double* psquaremin, bool process_units,Parameters* parameters);
		void Scale(double scale_factor);
		void AXPY(Input* xinput,double scalar);
		void Constrain(double cm_min, double cm_max);
		void GetVectorFromInputs(Vec vector,int* doflist);
		void GetValuesPtr(double** pvalues,int* pnum_values);
		/*}}}*/

};
#endif  /* _PENTAVERTEXINPUT_H */
