/*! \file PetscVecExternalResult.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _PETSCVECEXTERNALRESULT_H_
#define _PETSCVECEXTERNALRESULT_H_

/*Headers:*/
/*{{{1*/

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif


#include "./ExternalResult.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../include/include.h"
/*}}}*/

class PetscVecExternalResult: public ExternalResult{

	private: 
		int id;
		int enum_type;
		Vec value;
		int step;
		double time;

	public:
		/*constructors, destructors: {{{1*/
		PetscVecExternalResult();
		PetscVecExternalResult(int id,int enum_type,Vec value, int step, double time);
		~PetscVecExternalResult();
		/*}}}*/
		/*Object methods: {{{1*/
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		void  UpdateInputsFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void  UpdateInputsFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void  UpdateInputsFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}
		void  UpdateInputsFromSolution(double* solution){ISSMERROR("Not implemented yet!");}
		/*}}}*/
		/*ExternalResult methods: {{{1*/
		int   EnumType(){return enum_type;}
		/*}}}*/
};
#endif  /* _PETSCVECEXTERNALRESULT_H */
