/*!\file:  objectivefunctionC
 * \brief  objective function that returns a misfit, for a certain parameter.
 */ 

/*include files: {{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../solvers/solvers.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../include/include.h"
/*}}}*/

double objectivefunctionC(double search_scalar,OptArgs* optargs){

	int i;  
	
	/*output: */
	double J;
	
	/*parameters: */
	FemModel* femmodel=NULL;
	int     n;
	double* optscal=NULL;
	double* fit=NULL;
	double  cm_min;
	double  cm_max;
	int     control_type;
	int     analysis_type;
	int     control_steady;
	bool    conserve_loads=true;
	
	/*Recover finite element model: */
	femmodel=optargs->femmodel;

	/*Recover parameters: */
	n=optargs->n;

	femmodel->parameters->FindParam(&optscal,NULL,NULL,OptScalEnum);
	femmodel->parameters->FindParam(&fit,NULL,NULL,FitEnum);
	femmodel->parameters->FindParam(&cm_min,CmMinEnum);
	femmodel->parameters->FindParam(&cm_max,CmMaxEnum);
	femmodel->parameters->FindParam(&control_type,ControlTypeEnum);
	femmodel->parameters->FindParam(&control_steady,ControlSteadyEnum);
	femmodel->parameters->FindParam(&analysis_type,AnalysisTypeEnum);

	/*Use ControlParameterEnum input to  reinitialize our input parameter: */
	InputDuplicatex(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,ControlParameterEnum,control_type);
	
	/*Use search scalar to shoot parameter in the gradient direction: */
	InputAXPYx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,control_type,search_scalar*optscal[n],ControlParameterEnum);

	/*Constrain:*/
	ControlConstrainInputx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,control_type,cm_min,cm_max);

	/*Run diagnostic with updated inputs: */
	if(!control_steady) solver_diagnostic_nonlinear(NULL,NULL,NULL,femmodel,conserve_loads);  //true means we conserve loads at each diagnostic run
	else                diagnostic_core(femmodel);	//We need a 3D velocity!! (vz is required for the next thermal run)

	/*Compute misfit for this velocity field.*/
	UpdateInputsFromConstantx( femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters,fit[n],FitEnum);
	CostFunctionx( &J, femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials, femmodel->parameters);

	/*Free ressources:*/
	xfree((void**)&fit);
	xfree((void**)&optscal);
	return J;
}
