/*!\file: Sing.h
 * \brief prototypes for Sing element
 */ 

#ifndef _SING_H_
#define  _SING_H_

/*Headers:*/
/*{{{1*/
#include "./Element.h"
class Hook;
class Parameters;
class Inputs;
class IoModel;
class Node;
class Matice;
class Matpar;

#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"

/*}}}*/

class Sing: public Element{

	public:

		/*ids:*/
		int id;

		Node* node; 
		Matice* matice;
		Matpar* matpar;
		
		Parameters* parameters; //pointer to solution parameters
		Inputs* inputs;


		/*constructors, destructors: {{{1*/
		Sing();
		~Sing();
		void   Update(int index, IoModel* iomodel,int analysis_counter,int analysis_type);
		/*}}}*/
		/*object management: {{{1*/
		void  Configure(DataSet* elements,DataSet* loads,DataSet* nodes,DataSet* materials,Parameters* parameters);
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id(); 
		bool  IsInput(int name);
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  SetClone(int* minranks);
		int   MyRank();
		void  UpdateInputsFromVector(double* vector, int name, int type);
		void  UpdateInputsFromVector(int* vector, int name, int type);
		void  UpdateInputsFromVector(bool* vector, int name, int type);
		void  UpdateInputsFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void  UpdateInputsFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void  UpdateInputsFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}
		void  UpdateInputsFromSolution(double* solutiong);
		void  DepthAverageInputAtBase(int enum_type,int average_enum_type){ISSMERROR("not implemented yet");};
		void  InputToResult(int enum_type,int step,double time);
		void   ProcessResultsUnits(void);
		/*}}}*/
		/*numerics: {{{1*/
		void  CreateKMatrix(Mat Kggg);
		void  CreatePVector(Vec pg);
		void  GetDofList(int* doflist,int* pnumberofdofs);
		void  GetSolutionFromInputs(Vec solution);
		void  GetDofList1(int* doflist);
		void  CreateKMatrixDiagnosticHutter(Mat Kggg);
		void  GetParameterValue(double* pp, double* plist, double* gauss_l1l2l3);
		void  CreatePVectorDiagnosticHutter(Vec pgg);
		void* GetMatPar();
		void  ComputeBasalStress(Vec sigma_bg);
		void  ComputePressure(Vec p_gg);
		void  ComputeStrainRate(Vec epsg);
		void  GetNodes(void** vpnodes);
		void  PatchSize(int* pnumrows, int* pnumvertices,int* pnumnodes);
		void  PatchFill(int* pcount, Patch* patch);
		void  MinVel(double* pminvel, bool process_units);
		void  MaxVel(double* pmaxvel, bool process_units);
		void  MinVx(double* pminvx, bool process_units);
		void  MaxVx(double* pmaxvx, bool process_units);
		void  MaxAbsVx(double* pmaxabsvx, bool process_units);
		void  MinVy(double* pminvy, bool process_units);
		void  MaxVy(double* pmaxvy, bool process_units);
		void  MaxAbsVy(double* pmaxabsvy, bool process_units);
		void  MinVz(double* pminvz, bool process_units);
		void  MaxVz(double* pmaxvz, bool process_units);
		void  MaxAbsVz(double* pmaxabsvz, bool process_units);
		void  InputDuplicate(int original_enum,int new_enum);
		void  ScaleInput(int enum_type,double scale_factor);
		void  InputAXPY(int YEnum, double scalar, int XEnum);
		void  InputConvergence(int* pconverged,double* eps, int* enums,int num_enums,int* criterionenums,double* criterionvalues,int num_criterionenums);
		void  ControlConstrainInput(int control_type,double cm_min, double cm_max);


		/*}}}*/
		/*not implemented: {{{1*/
		bool   GetShelf();
		bool   GetOnBed();
		void  GetBedList(double*);
		void  GetThicknessList(double* thickness_list);
		void  Du(Vec);
		void  Gradj(Vec gradient,int control_type);
		void  GradjDrag(Vec gradient);
		void  GradjB(Vec gradient);
		double Misfit(void);
		double SurfaceArea(void);
		double CostFunction(void);
		double MassFlux(double* segment);
		void  GetVectorFromInputs(Vec vector,int NameEnum);
		/*}}}*/



};
#endif //ifndef _SING_H_

