/*!\file: prognostic_core.cpp
 * \brief: core of the prognostic solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../solvers/solvers.h"

void prognostic_core(FemModel* femmodel){

	/*parameters: */
	int verbose=0;

	/*activate formulation: */
	femmodel->SetCurrentAnalysis(PrognosticAnalysisEnum);
	
	/*recover parameters: */
	femmodel->parameters->FindParam(&verbose,VerboseEnum);

	_printf_("depth averaging velocity...\n");
	DepthAverageInputx(femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,femmodel->parameters,VxEnum,VxAverageEnum);
	DepthAverageInputx(femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,femmodel->parameters,VyEnum,VyAverageEnum);
	
	_printf_("call computational core:\n");
	solver_linear(NULL,femmodel);
		
	_printf_("extrude computed thickness on all layers:\n");
	InputExtrudex(femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,femmodel->parameters,ThicknessEnum);

	if(verbose)_printf_("saving results:\n");
	InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,ThicknessEnum);
	
}

