/*!\file: surfaceslope_core.cpp
 * \brief: core of the slope solution 
 */ 

#include "./solutions.h"
#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../solvers/solvers.h"
#include "../modules/modules.h"

void surfaceslope_core(FemModel* femmodel){

	/*parameters: */
	int verbose;
	int dim;
	bool isstokes;
	bool ishutter;

	/*Recover some parameters: */
	femmodel->parameters->FindParam(&verbose,VerboseEnum);
	femmodel->parameters->FindParam(&dim,DimEnum);

	if(verbose)_printf_("%s\n","computing slope...");

	/*Call on core computations: */
	femmodel->SetCurrentAnalysisAlias(SlopeAnalysisEnum,SurfaceSlopeXAnalysisEnum);
	solver_linear(NULL,femmodel);
	femmodel->SetCurrentAnalysisAlias(SlopeAnalysisEnum,SurfaceSlopeYAnalysisEnum);
	solver_linear(NULL,femmodel);
	
	/*extrude inputs if we are in 3D: */
	if (dim==3){
		if(verbose)_printf_("%s\n","extruding slope in 3d...");
		InputExtrudex(femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,femmodel->parameters,SurfaceSlopeXEnum);
		InputExtrudex(femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,femmodel->parameters,SurfaceSlopeYEnum);
	}
	
	if(verbose)_printf_("saving results:\n");
	InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,SurfaceSlopeXEnum);
	InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,SurfaceSlopeYEnum);

}
