/*!\file DuplicateInputx
 * \brief: duplicte  an input inside the elements, onto another, and wipe it off.
 */

#include "./DuplicateInputx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void DuplicateInputx(DataSet* elements,DataSet* nodes,DataSet* vertices,DataSet* loads,DataSet* materials,Parameters* parameters,int reinitialized_enum, int original_enum){

	/*intermediary:*/
	int      i;

	/*First, get elements and nodes configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Go through elemnets, and ask to reinitialie the input: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->DuplicateInput(reinitialized_enum,original_enum);
	}

}
