/*! \file IntParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _INTPARAM_H_
#define _INTPARAM_H_

/*Headers:*/
/*{{{1*/

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif


#include "./Param.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../include/include.h"
/*}}}*/

class IntParam: public Param{

	private: 
		/*just hold 3 values for 3 vertices: */
		int enum_type;
		IssmInt value;

	public:
		/*constructors, destructors: {{{1*/
		IntParam();
		IntParam(int enum_type,IssmInt value);
		~IntParam();
		/*}}}*/
		/*Object methods: {{{1*/
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		void  UpdateInputsFromVector(double* vector, int name, int type);
		void  UpdateInputsFromVector(int* vector, int name, int type);
		void  UpdateInputsFromVector(bool* vector, int name, int type);
		void  UpdateInputsFromConstant(double constant, int name);
		void  UpdateInputsFromConstant(int constant, int name);
		void  UpdateInputsFromConstant(bool constant, int name);
		void  UpdateInputsFromSolution(double* solution){ISSMERROR("Not implemented yet!");}

		/*}}}*/
		/*Param methods: {{{1*/
		int   EnumType(){return enum_type;}
		void  GetParameterValue(bool* pbool){ISSMERROR("Int param of enum %i (%s) cannot return a bool",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(int* pinteger){*pinteger=value;}
		void  GetParameterValue(double* pdouble){ISSMERROR("Int param of enum %i (%s) cannot return a double",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(char** pstring){ISSMERROR("Int param of enum %i (%s) cannot return a string",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(char*** pstringarray,int* pM){ISSMERROR("Int param of enum %i (%s) cannot return a string arrayl",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM){ISSMERROR("Int param of enum %i (%s) cannot return a double array",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM, int* pN){ISSMERROR("Int param of enum %i (%s) cannot return a double array",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(Vec* pvec){ISSMERROR("Int param of enum %i (%s) cannot return a Vec",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(Mat* pmat){ISSMERROR("Int param of enum %i (%s) cannot return a Mat",enum_type,EnumAsString(enum_type));}

		void  SetValue(bool boolean){this->value=(int)boolean;}
		void  SetValue(int integer){this->value=integer;}
		void  SetValue(double scalar){this->value=(int)scalar;}
		void  SetValue(char* string){ISSMERROR("Int param of enum %i (%s) cannot hold a string",enum_type,EnumAsString(enum_type));}
		void  SetValue(char** stringarray,int M){ISSMERROR("Int param of enum %i (%s) cannot hold a string array",enum_type,EnumAsString(enum_type));}
		void  SetValue(double* doublearray,int M){ISSMERROR("Int param of enum %i (%s) cannot hold a double array",enum_type,EnumAsString(enum_type));}
		void  SetValue(double* pdoublearray,int M,int N){ISSMERROR("Int param of enum %i (%s) cannot hold a double array",enum_type,EnumAsString(enum_type));}
		void  SetValue(Vec vec){ISSMERROR("Int param of enum %i (%s) cannot hold a Vec",enum_type,EnumAsString(enum_type));}
		void  SetValue(Mat mat){ISSMERROR("Int param of enum %i (%s) cannot hold a Mat",enum_type,EnumAsString(enum_type));}

		char* GetParameterName(void);
		void  Process(double* partition,int numberofvertices);
		#ifdef _SERIAL_
		void  SetMatlabField(mxArray* dataref);
		#endif

		/*}}}*/
};
#endif  /* _INTPARAM_H */
